import mpi.*;
import java.nio.ByteBuffer ;
import java.io.* ; 

public class Bandwidth_OpenMPI {
  public Bandwidth_OpenMPI() {
  }
  public Bandwidth_OpenMPI(String[] args) throws Exception {  
	int WARM_UP = 15000 ;
    int REPEAT = 35000 ;
    long[] delays = new long[REPEAT];
    long latency = 0L;
    long start= 0L, stop=0L, init = 0L;
    MPI.Init(args);				
    int me = MPI.COMM_WORLD.getRank(); 
  //  System.out.println("Name ="+MPI.Get_processor_name());
    byte byteArray [] = null;
    int j=1, i=0;   	       		   	
    int LOG2N_MAX = 1000000,log2nbyte=0,padding=0;	
    long timed = 0L;		
    byteArray = new byte[16777216];
    PrintStream out = null ;
    FileOutputStream fos = null ;

    
    for(i =0;i < byteArray.length;i++) {
      byteArray[i] = 's';
    }


    /* Logrithmic Loop */
    for (log2nbyte = 10; log2nbyte<= LOG2N_MAX && j<16*1024*1024; ++log2nbyte) { 

        //MPI.COMM_WORLD.Barrier();

	j = (1 << log2nbyte);

        for(i=0;i < WARM_UP ;i++) {
          if(me == 0) {
			  
			//System.out.println("calling recv "+me);  
            MPI.COMM_WORLD.recv(byteArray,1,MPI.BYTE,1,998);
           // System.out.println("calling send "+me);
            MPI.COMM_WORLD.send(byteArray,1,MPI.BYTE,1,998);
          }
          else if(me == 1) {
			//System.out.println("calling send "+me);    
            MPI.COMM_WORLD.send(byteArray,1,MPI.BYTE,0,998);
           // System.out.println("calling recv "+me);  
            MPI.COMM_WORLD.recv(byteArray,1,MPI.BYTE,0,998);
          }
        }

        start = System.nanoTime();

	/* Latency Calculation Loop */
	for (i = 0; i < REPEAT ; i++) {	   			
	  if(me == 0) {
		   // System.out.println("calling send "+me);
            MPI.COMM_WORLD.send(byteArray,j,MPI.BYTE,1,998);	
          //  System.out.println("calling recv "+me);     		  	    
	    MPI.COMM_WORLD.recv(byteArray,j,MPI.BYTE,1,998);
	  } else if(me == 1) {
		 // System.out.println("calling recv "+me);  
            MPI.COMM_WORLD.recv(byteArray,j,MPI.BYTE,0,998);
         //   System.out.println("calling send "+me);
            MPI.COMM_WORLD.send(byteArray,j,MPI.BYTE,0,998);			
	  }
	}
      
        stop = System.nanoTime();


	latency = (((stop-start)/(REPEAT*2))/1000);

	if(me == 0) { 
          System.out.println(j+"\t"+(latency)+
		               "\t"+
            (( 8*j ) /( 1024*1024* (latency/(1000.0*1000)))) );
	}

        MPI.COMM_WORLD.barrier() ;   
    }//end logrithmic loop

    MPI.Finalize();	  	
  }//end args constructor.

  public static void main(String[] args) throws Exception { 
 
    Bandwidth_OpenMPI bw = new Bandwidth_OpenMPI(args) ; 
  } 
 
}//end class.
